/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ISortableTool;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.ICustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemManasteelShovel
extends ShovelItem
implements ICustomDamageItem,
ISortableTool {
    private static final int MANA_PER_DAMAGE = 60;

    public ItemManasteelShovel(Item.Properties props) {
        this(BotaniaAPI.instance().getManasteelItemTier(), props);
    }

    public ItemManasteelShovel(Tier mat, Item.Properties props) {
        super(mat, 1.5f, -3.0f, props);
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int manaPerDamage = ((ItemManasteelShovel)stack.m_41720_()).getManaPerDamage();
        return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPerDamage);
    }

    public int getManaPerDamage() {
        return 60;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaPerDamage() * 2, true)) {
                stack.m_41721_(stack.m_41773_() - 1);
            }
        }
    }

    @Override
    public int getSortingPriority(ItemStack stack, BlockState state) {
        return ToolCommons.getToolPriority(stack);
    }
}

